//DrawFloorOne.scad;

include <UNO_Dimensions.scad>;
use <UNO_Floor.scad>;
use <UNO_FloorMountingPosts.scad>;
use <UNO_FloorMountingPostGaps.scad>;
use <UNO_FloorMagnetRecesses.scad>;
use <UNO_LidScrewThreads.scad>;
use <UNO_LidScrewHeads.scad>;
use <UNO_FloorFillGaps.scad>;

//FloorOne is the lower floor;
//It carries the fillers for the holes 
//for the USB and DC connectors, 
//but not the mounting posts for the UNO;

ThreadHole = LidScrewThreadPhi;

//color("Blue")
//    FloorMagnetRecesses();

difference()
{
    Floor();
    FloorMountingPostGaps();
    FloorMagnetRecesses();
    LidScrewThreads(ThreadHole);
    LidScrewHeads();
}


FloorFillGaps();
translate([USBfillerX -Whisker, 0, 0])
FloorFillGaps();

//
